﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.Model;

namespace IndianHealthService.BMXNet.CIA
{
    internal class CiaEncounter : CiaObject, Encounter
    {
        public static CiaEncounter FindCurrent(CiaSession aSession)
        {
            if (aSession.CssEncounter.VisitStr == null) return null;

            String[] peices = aSession.CssEncounter.VisitStr.Split(new char[] { ';' });

            if (peices.Length == 4)
            {
                CiaEncounter answer = new CiaEncounter();
                answer.Ien = peices[3];
                answer.Ien = answer.Ien = peices[3];
                answer.DateTime = aSession.CssEncounter.DateTime;
                answer.LocationName = aSession.CssEncounter.LocationName;
                answer.ProviderName = aSession.CssEncounter.ProviderName;

                return answer;
            }
            else
            {
                return null;
            }
        }


        private String _clinic = null;

        public String Clinic
        {
            get { return _clinic; }
            set { _clinic = value; }
        }
        private String _providerName;

        public String ProviderName
        {
            get { return _providerName; }
            set { _providerName = value; }
        }
        private String _locationName;

        public String LocationName
        {
            get { return _locationName; }
            set { _locationName = value; }
        }
        private DateTime _dateTime;

        public DateTime DateTime
        {
            get { return _dateTime; }
            set { _dateTime = value; }
        }
    }
}